// tropicalBookingStyles.js
export default function getTropicalStyles(theme) {
    return `
    

      .tropical-bookings-page {
        background-color: ${theme.creamBg};
        min-height: 100vh;
        position: relative;
        overflow-x: hidden;
      }
      .rainforest-bg { /* BG animations remain same */
        position: fixed; top: 0; left: 0; width: 100%; height: 100%;
        pointer-events: none; z-index: 0; overflow: hidden;
      }
      .bg-leaf-animated {
        position: absolute;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 150'%3E%3Cpath d='M50 0 C20 50 20 100 50 150 C80 100 80 50 50 0 Z' fill='${theme.accent.replace('#', '%23')}' opacity='0.07'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-size: contain;
        animation: float-gentle 15s ease-in-out infinite alternate;
      }
      .bg-leaf-animated.leaf-1 { width: 250px; height: 375px; top: 5%; left: -80px; animation-duration: 18s; opacity: 0.07; }
      .bg-leaf-animated.leaf-2 { width: 200px; height: 300px; top: 50%; right: -60px; transform: rotate(45deg) scaleX(-1); animation-duration: 22s; animation-delay: -5s; opacity: 0.06;}
      .bg-leaf-animated.leaf-3 { width: 150px; height: 225px; bottom: 0%; left: 15%; transform: rotate(-25deg); animation-duration: 16s; animation-delay: -10s; opacity: 0.05;}
      .bg-sunlight-flare {
        position: absolute; top: -25%; right: -25%; width: 70%; height: 70%;
        background: radial-gradient(circle, ${theme.secondary}26 0%, transparent 70%);
        border-radius: 50%;
        animation: pulse-fade 12s ease-in-out infinite alternate;
      }
      @keyframes float-gentle {
        0% { transform: translateY(0px) translateX(0px) rotate(-2deg); }
        50% { transform: translateY(-20px) translateX(10px) rotate(3deg); }
        100% { transform: translateY(0px) translateX(0px) rotate(-2deg); }
      }
      @keyframes pulse-fade {
        0% { opacity: 0.2; transform: scale(0.95) rotate(0deg); }
        50% { opacity: 0.5; transform: scale(1.05) rotate(5deg); }
        100% { opacity: 0.2; transform: scale(0.95) rotate(0deg); }
      }

      .booking-tabs-nav {
        position: sticky; top: 0; z-index: 10;
        /* border-bottom: 1px solid ${theme.secondary} !important; */ /* Changed this to allow active tab to "merge" */
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      }
      .booking-tab-item {
        font-weight: 500 !important; letter-spacing: 0.2px; text-transform: none !important;
        transition: background-color 0.3s ease, color 0.3s ease;
        border-top-left-radius: 0;
        border-top-right-radius: 0;
      }
      .booking-tab-item .v-icon { margin-right: 8px; }
      .booking-tab-item-active { /* NEW: Active tab styling */
        background-color: ${theme.creamBg} !important;
        color: ${theme.primary} !important;
        border-top-left-radius: 8px !important;
        border-top-right-radius: 8px !important;
        margin-bottom: -0px; /* Adjust if slider needs to align */
        border-bottom: none !important; /* Hide bottom border if any from v-tabs */
      }
      .booking-tab-item-active .v-icon {
         color: ${theme.primary} !important;
      }
      .v-tabs__slider {
        height: 3px !important; /* Make slider a bit thicker */
      }


      .tropical-booking-main-content { position: relative; z-index: 1; }
      
      .content-card {
        background-color: ${theme.lightBg}E6 !important;
        border-radius: 16px !important;
        border: 1px solid ${theme.accent}4D;
        overflow: hidden;
        backdrop-filter: blur(5px);
      }
      .card-header {
        font-weight: bold;
        border-bottom: 1px solid ${theme.secondary}80;
        padding: 12px 16px !important;
      }
      .card-header .v-icon { margin-right: 8px; }
      .card-header-mobile { font-size: 1rem !important; padding: 10px 12px !important; }
      .card-header-mobile .v-icon { font-size: 1.1rem !important;}


      .themed-date-picker { background-color: transparent !important; }
      .themed-date-picker .v-date-picker-header { background-color: ${theme.primary} !important; }
      .themed-date-picker .v-date-picker-header .v-btn { color: ${theme.lightText} !important; }
      .themed-date-picker .v-date-picker-month .v-btn--active { color: ${theme.lightText} !important; }
      .themed-date-picker .v-date-picker-table .v-btn--active:not(.v-btn--disabled) { background-color: ${theme.primary} !important; color: ${theme.lightText} !important; }
      .selected-date-info { font-size: 0.9rem; }

      .category-list .v-list-item {
        margin: 4px 8px; /* Add some horizontal margin for rounded effect */
        border-left: 4px solid transparent;
        transition: background-color 0.2s, border-left-color 0.2s;
      }
       .category-list .v-list-item:not(.v-list-item--active):hover {
         background-color: ${theme.accent}33;
         border-left-color: ${theme.accent};
       }
      .category-list .v-list-item--active {
        /* Active color is handled by :active-color prop on v-list-item */
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
      }
      
      .facility-selection-list .facility-item {
        background-color: #fff;
        transition: transform 0.2s ease-out, box-shadow 0.2s ease-out, border-left-color 0.3s ease;
        border-left: 5px solid transparent;
      }
      .facility-selection-list .facility-item:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 15px rgba(0,0,0,0.1) !important;
        border-left-color: ${theme.secondary};
      }
      .facility-name { line-height: 1.3; }

      .time-slot-grid { max-height: 480px; overflow-y: auto; padding-right: 4px; margin: -4px; }
      .time-slot-grid .v-col { padding: 4px !important; }
      .time-slot-item {
        cursor: pointer;
        transition: all 0.2s ease-in-out;
        height: 100%; display: flex; flex-direction: column; justify-content: center;
      }
      .time-slot-item.available { border: 1px solid ${theme.accent}; background-color: #fff; }
      .time-slot-item.available:hover {
        background-color: ${theme.accent}4D;
        border-color: ${theme.primary};
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1) !important;
      }
      .time-slot-item.booked {
        background-color: ${theme.creamBg}BF;
        opacity: 0.7; cursor: not-allowed;
        border: 1px dashed ${theme.muted};
      }
      .time-slot-item .time-display { font-size: 0.85rem; } /* Slightly smaller for mobile */
      .time-slot-item .status-chip-small { font-size: 0.65rem; height: 18px; padding: 0 5px;}
      .time-slot-item .price-display { font-size: 0.75rem; }

      .empty-bookings-state {
        background-color: ${theme.accent}20;
        border-radius: 12px;
        border: 1px dashed ${theme.accent};
      }
      .themed-expansion-panels .booking-panel-item {
        margin-bottom: 12px !important;
        border-radius: 12px !important;
        border-left: 5px solid;
        background-color: #fff !important;
      }
      .themed-expansion-panels .v-expansion-panel-title { padding: 10px 12px; min-height: 60px; }
      .themed-expansion-panels .booking-panel-title-mobile { padding: 8px 10px; min-height: 56px; }
      .themed-expansion-panels .booking-panel-content .v-expansion-panel-text__wrapper { padding: 8px 12px 12px; }
      .themed-expansion-panels .booking-panel-content { background-color: ${theme.lightBg}99 !important; }
      .themed-expansion-panels .status-chip-panel { font-weight: 500; }
      .themed-expansion-panels .past-booking { opacity: 0.85; }
      .list-mobile-dense .v-list-item { min-height: 36px !important; }
      .list-mobile-dense .v-list-item .v-icon { font-size: 0.9rem !important; }
      .list-mobile-dense .v-list-item .v-list-item-title, .list-mobile-dense .v-list-item strong { font-size: 0.8rem !important; }


      .booking-dialog-card .v-toolbar-title, .cancel-dialog-card .v-toolbar-title { font-size: 1.1rem; font-weight: 500; }
      .dialog-title { font-size: 1rem !important; } /* For mobile fullscreen dialogs */
      .v-dialog--fullscreen .v-toolbar-title { margin-left: 0; }
      .v-dialog--fullscreen .v-card-text { flex-grow: 1; overflow-y: auto; }
      .v-dialog .v-overlay__content { border-radius: 16px !important; overflow: hidden !important; }
      .v-dialog--fullscreen .v-overlay__content { border-radius: 0 !important; }
      .dialog-actions-sticky { /* For fullscreen dialogs to stick actions at bottom */
        position: sticky;
        bottom: 0;
        background-color: ${theme.lightBg};
        border-top: 1px solid ${theme.accent}4D;
        z-index: 1;
      }


      /* General Mobile Font Adjustments */
      @media (max-width: 600px) {
        .booking-tab-item { font-size: 0.8rem !important; padding: 0 8px !important; min-width: auto !important; }
        .booking-tab-item .v-icon { margin-right: 4px !important; font-size: 1rem !important; }
        .text-h6 { font-size: 1.05rem !important; }
        .text-subtitle-1 { font-size: 0.9rem !important; }
        .text-body-1 { font-size: 0.85rem !important; }
        .text-body-2 { font-size: 0.8rem !important; }
        .text-caption { font-size: 0.7rem !important; }
        .v-btn { --v-btn-height: 32px !important; font-size: 0.8rem !important; } /* Smaller buttons */
        .v-btn--size-large { --v-btn-height: 38px !important; }
        .v-btn--size-small { --v-btn-height: 28px !important; }
        .v-btn--size-x-small { --v-btn-height: 22px !important; font-size: 0.7rem !important; }
        .v-chip--size-small { height: 22px !important; font-size: 0.7rem !important; }
        .v-chip--size-x-small { height: 18px !important; font-size: 0.65rem !important; }
      }
  
    
    `;
  }
  