// CategoryButton component
const CategoryButton = {
    props: {
      category: {
        type: Object,
        required: true
      },
      activeCategory: {
        type: String,
        required: true
      }
    },
    computed: {
      isActive() {
        return this.category.id === this.activeCategory;
      }
    },
    methods: {
      onClick(categoryId) {
        this.$emit('category-click', categoryId);
      }
    },
    template: `
      <button
        @click="onClick(category.id)"
        :class="'relative px-4 py-2 rounded-full font-medium text-sm transition-all duration-300 ease-in-out ' + 
          (isActive 
            ? 'bg-gray-900 text-white shadow-lg min-w-24 scale-105' 
            : 'bg-gray-100 text-gray-700 hover:bg-gray-200 min-w-20')"
      >
        <div class="flex items-center justify-center gap-2">
          <span class="text-lg">{{ category.icon }}</span>
          <span>{{ category.name }}</span>
        </div>
        
        <!-- Pill expansion animation -->
        <div 
          :class="'absolute inset-0 rounded-full transition-all duration-500 ease-in-out ' + 
            (isActive ? 'opacity-100' : 'opacity-0')"
        />
      </button>
    `
  };