export default {
  props: ["jsonData"],
  data() {
    return {
      
      chatList: [

        {
          name: "Project Team",
          last_message: "Let's meet tomorrow.",
          time: "12:45 PM",
        },
        {
          name: "Support",
          last_message: "Ticket has been resolved.",
          time: "11:30 AM",
        }


      ],


      loading: false,
      module: "chat",
      method: "get_group_list",



    };
  },
  
  methods: {
    

    async loadChatList() {
      this.loading = true;
      try {
        const response = await this.$root.callApi(this.module, this.method, {});
        if (response?.data) {
          //this.chatList = response.data;
        } else {
          //alert("No chat groups found.");
        }
      } catch (error) {
        console.error("Failed to load chat groups", error);
      } finally {
        this.loading = false;
      }
    },


    openChatRoom(chat) {
      const chatInfo = {
        chat_id: chat.id,
        name: chat.name,
      };

      this.$root.bottomNavDisplay =false;
      // Load external message.js with selected chat info
      this.$root.loadComponent("modules/message.js", chatInfo);
    }





    
    
  },
  template: `
    

  <v-toolbar :elevation="8" title="Chat" color="black" ></v-toolbar>



       <div >
      <v-progress-circular
        v-if="loading"
        indeterminate
        color="primary"
        class="d-flex mx-auto mt-10"
      ></v-progress-circular>




<v-container fluid class="pa-0">


      <v-list v-else two-line>


          <v-list v-else two-line>
            
          



               <v-list-item
                  v-for="(chat, index) in chatList"
                  :key="index"
                    @click="openChatRoom(chat)"
                  
                  class="chat-list-item pa-5"
                >




                 <v-list-item-title>{{ chat.name }}</v-list-item-title>

                    <p>{{ chat.last_message }}</p>


                    <v-list-item-subtitle class="mb-1 text-high-emphasis opacity-100">
                      {{ chat.time }}
 
                   
                   </v-list-item-subtitle>
 
                    


                  <template v-slot:prepend>
                    <v-avatar color="black">
                      <span class="white--text text-h6">{{ chat.name[0] }}</span>
                        
                    </v-avatar>
                  </template>

              <template v-slot:append>
                  
              </template>


            
            </v-list-item>

              



          </v-list>



</v-container>




    </div>

  `,
  async mounted(){
    
    


    this.loadChatList();

    


  }
};