export default {
  props: ["jsonData"],
  data() {
    return {
      
      
      chat_id: null,
      chat_name: "",
      messages: [],
      newMessage: "",
      loading: false,
      module: "chat",
      method: "get_chat_log",


      botReplies: [
        "Got it!",
        "Interesting 🤔",
        "Can you explain more?",
        "Sounds good to me.",
        "👍 Sure thing!",
        "I'll take note of that.",
        "Let's discuss that soon.",
        "That's a good idea!"
      ],


      taskSheet: false,
        newTask: {
          name: '',
          due_date: '',
          description: '',
          assignee: ''
        },



      imageFile: null,




    };
  },
  
  methods: {
    
        
          loadMessages() {
            // Mock message data
            this.messages = [
              { text: "Hi there!", from_me: false },
              { text: "Welcome to the chat room.", from_me: true },
              { text: "How can I help you today?", from_me: false }
            ];

            this.$nextTick(() => {
              this.scrollToBottom();
            });
          },



         sendMessage() {
            const msg = this.newMessage.trim();
            if (!msg) return;

            // Push user message
            this.messages.push({
              text: msg,
              from_me: true
            });

            this.newMessage = "";

            this.$nextTick(this.scrollToBottom);

            // Simulate bot reply after delay
            setTimeout(() => {
              const reply = this.getRandomReply();
              this.messages.push({
                text: reply,
                from_me: false
              });

              this.$nextTick(this.scrollToBottom);
            }, 1000); // 1s delay
          },


          getRandomReply() {
            const index = Math.floor(Math.random() * this.botReplies.length);
            return this.botReplies[index];
          },




          openTaskSheet() {
            this.taskSheet = true;
          },




          submitTask() {
            if (!this.newTask.name.trim()) {
              alert("Task name is required.");
              return;
            }

            const taskCopy = { ...this.newTask };

            // Simulate as a message
            this.messages.push({
              type: 'task',
              from_me: true,
              task: taskCopy
            });

            // Reset
            this.newTask = {
              name: '',
              due_date: '',
              description: '',
              assignee: ''
            };

            this.taskSheet = false;
            this.$nextTick(this.scrollToBottom);
          },









          handleImageUpload(event) {
            const file = event.target.files[0];
            if (!file || !file.type.startsWith("image/")) return;
          
            const reader = new FileReader();
            reader.onload = (e) => {
              const imageData = e.target.result;
              this.messages.push({
                type: "image",
                from_me: true,
                image: imageData,
              });
          
              this.$nextTick(this.scrollToBottom);
            };
            reader.readAsDataURL(file);
          },




          // async loadMessages() {
          //   this.loading = true;

          //   const queryData = {
          //     chat_id: this.chat_id,
          //   };

          //   try {
          //     const response = await this.$root.callApi(this.module, this.method, queryData);
          //     if (response?.data) {
          //       this.messages = response.data;
          //     } else {
          //       alert("Failed to load messages.");
          //     }
          //   } catch (error) {
          //     console.error("Error loading messages:", error);
          //   } finally {
          //     this.loading = false;
          //     this.$nextTick(() => {
          //       this.scrollToBottom();
          //     });
          //   }
          // },
          // async sendMessage() {
          //   if (!this.newMessage.trim()) return;

          //   const postData = {
          //     chat_id: this.chat_id,
          //     message: this.newMessage,
          //   };

          //   const response = await this.$root.callApi("chat", "send_message", postData);

          //   if (response?.status === "success") {
          //     this.newMessage = "";
          //     this.loadMessages(); // Reload after send
          //   }
          // },




          goBack() {
            
            this.$root.bottomNavDisplay =true;
            this.$root.loadComponent("modules/chat.js");
            
          },
          scrollToBottom() {
            const container = this.$refs.messageContainer;
            if (container) {
              container.scrollTop = container.scrollHeight;
            }
          }


    
    
  },
  template: `
        
        
      <div class="chat-room-container">
          <v-app-bar dense flat color="black">
            <v-btn icon @click="goBack">
              <v-icon>mdi-arrow-left</v-icon>
            </v-btn>
            <v-toolbar-title>{{ chat_name }}</v-toolbar-title>
          </v-app-bar>

          <v-container fluid class="chat-messages" ref="messageContainer">
            <v-row dense>


                   <v-col
                    v-for="(msg, index) in messages"
                    :key="index"
                    cols="12"
                    :class="msg.from_me ? 'text-right' : 'text-left'"
                  >
                    <!-- Task Message -->
                    <div
                      v-if="msg.type === 'task'"
                      :class="['task-bubble', msg.from_me ? 'sent' : 'received']"
                    >
                      <strong>📝 {{ msg.task.name }}</strong><br />
                      <small>Due: {{ msg.task.due_date }}</small><br />
                      <small>Assigned to: {{ msg.task.assignee }}</small><br />
                      <p>{{ msg.task.description }}</p>
                    </div>

                    <!-- Image Message -->
                    <div
                      v-else-if="msg.type === 'image'"
                      :class="['image-bubble', msg.from_me ? 'sent' : 'received']"
                    >
                      <img :src="msg.image" alt="Image" class="chat-image" />
                    </div>

                    <!-- Text Message -->
                    <div
                      v-else
                      :class="['message-bubble', msg.from_me ? 'sent' : 'received']"
                    >
                      {{ msg.text }}
                    </div>
                  </v-col>


            </v-row>
          </v-container>

        




          <v-footer app color="white" class="pa-2">


            <v-btn icon color="black" @click="openTaskSheet" class="ma-1">
              <v-icon>mdi-clipboard-plus-outline</v-icon>
            </v-btn>


             <v-btn icon color="black darken-1" @click="$refs.imageInput.click()" class="ma-1">
              <v-icon>mdi-paperclip</v-icon>
            </v-btn>

            <input
              ref="imageInput"
              type="file"
              accept="image/*"
              @change="handleImageUpload"
              style="display: none"
            />


            
            <v-text-field
              v-model="newMessage"
              label="Type a message"
              hide-details
              variant="outlined"
              density="compact"
              @keydown.enter.prevent="sendMessage"
            ></v-text-field>

            <v-btn icon color="black" @click="sendMessage" class="ma-1">
              <v-icon>mdi-send</v-icon>
            </v-btn>


          </v-footer>



          <v-bottom-sheet v-model="taskSheet" inset>
            <v-card>
              <v-card-title>Add New Task</v-card-title>
              <v-card-text>
                <v-text-field
                  label="Task Name"
                  v-model="newTask.name"
                  required
                ></v-text-field>

                <v-text-field
                  label="Assignee"
                  v-model="newTask.assignee"
                ></v-text-field>

                <v-textarea
                  label="Description"
                  v-model="newTask.description"
                  rows="2"
                ></v-textarea>

                <v-text-field
                  v-model="newTask.due_date"
                  label="Due Date"
                  type="date"
                ></v-text-field>
              </v-card-text>
              <v-card-actions>
                <v-spacer></v-spacer>
                <v-btn text @click="taskSheet = false">Cancel</v-btn>
                <v-btn color="black" @click="submitTask">Save</v-btn>
              </v-card-actions>
            </v-card>
          </v-bottom-sheet>



        </div>



        
        
  `,
  async mounted(){
    

    this.$root.bottomNavDisplay =false;

    this.chat_id = this.jsonData.chat_id;
    this.chat_name = this.jsonData.name;
    this.loadMessages();

  }
};