export default {
  props: ["jsonData"],
  data() {
    return {

      tasks: [],
      filteredTasks: [],
      selectedStatus: "All",

      

      statusOptions: [
        { label: "", value: "All", icon: "mdi-format-list-bulleted" },
        { label: "", value: "Pending", icon: "mdi-clock-outline" },
        { label: "", value: "In Progress", icon: "mdi-progress-clock" },
        { label: "", value: "Done", icon: "mdi-check-circle-outline" }
      ],


      
      module: "task",
      method: "get_task_list",
      loading: false,

    };
  },
  
  methods: {



        
        async loadTasks() {
          this.loading = true;

          try {
            // For demo, use static data
            this.tasks = [
              {
                id: 1,
                name: "Prepare monthly report",
                due_date: "2025-05-20",
                status: "Pending",
                assignee: "John"
              },
              {
                id: 2,
                name: "Fix bug #543",
                due_date: "2025-05-22",
                status: "In Progress",
                assignee: "Alice"
              },
              {
                id: 3,
                name: "Design landing page",
                due_date: "2025-05-25",
                status: "Done",
                assignee: "Emma"
              }
            ];

            this.filterTasks();
          } catch (e) {
            alert("Failed to load tasks");
          } finally {
            this.loading = false;
          }
        },



        filterTasks() {
          if (this.selectedStatus === "All") {
            this.filteredTasks = this.tasks;
          } else {
            this.filteredTasks = this.tasks.filter(
              (task) => task.status === this.selectedStatus
            );
          }
        },




        openTaskDetail(task) {
          this.$root.loadComponent("modules/task_detail.js", { task_id: task.id });
        }
    
    
  },
  template: `
    
        <v-toolbar :elevation="8" title="Task" color="black" ></v-toolbar>


         <v-container>

          <v-row>
            <v-col cols="12">

            
             <v-container fluid class="pa-0">
                
                <v-btn-toggle
                    v-model="selectedStatus"
                    class="mb-4 w-100 "
                    mandatory
                    
                     
                    @update:modelValue="filterTasks"
                    divided
                    rounded

                    
                  >
                    <v-btn
                      v-for="status in statusOptions"
                      :key="status.value"
                      :value="status.value"
                      class="d-flex flex-column align-center text-capitalize"
                      :class="selectedStatus === status.value ? 'active-status-btn' : 'inactive-status-btn'"
                      variant="flat"
                      
                    >
                      <v-icon class="mb-1" size="20">{{ status.icon }}</v-icon>
                      {{ status.label }}
                    </v-btn>
                  </v-btn-toggle>

              </v-container>




            </v-col>
          </v-row>




          <v-progress-circular v-if="loading" indeterminate class="mx-auto"></v-progress-circular>

          <v-list v-else>
            <v-list-item
              v-for="task in filteredTasks"
              :key="task.id"
              @click="openTaskDetail(task)"
            >
              <v-list-item-content>
                <v-list-item-title class="font-weight-medium">{{ task.name }}</v-list-item-title>
                <v-list-item-subtitle>
                  Due: {{ task.due_date }} | Assigned to: {{ task.assignee }}
                </v-list-item-subtitle>
              </v-list-item-content>

              <v-list-item-action>
                <v-chip
                  :color="task.status === 'Done' ? 'green' : task.status === 'In Progress' ? 'orange' : 'grey'"
                  text-color="white"
                  small
                >
                  {{ task.status }}
                </v-chip>
              </v-list-item-action>
            </v-list-item>
          </v-list>
        </v-container>
   

  `,
  async mounted(){
    
    this.loadTasks();

  }
};