export default {
  props: ["jsonData"],
  data() {
    return {

      task_id: null,
      task: null,
      loading: false

    };
  },
  
  methods: {

        async loadTaskDetail() {
          this.loading = true;

          try {
            // Mock task detail
            const mockTasks = [
              {
                id: 1,
                name: "Prepare monthly report",
                description: "Compile data and format for presentation.",
                due_date: "2025-05-20",
                status: "Pending",
                assignee: "John"
              },
              {
                id: 2,
                name: "Fix bug #543",
                description: "Related to user login crash on iOS.",
                due_date: "2025-05-22",
                status: "In Progress",
                assignee: "Alice"
              },
              {
                id: 3,
                name: "Design landing page",
                description: "Marketing page for the new feature release.",
                due_date: "2025-05-25",
                status: "Done",
                assignee: "Emma"
              }
            ];

            this.task = mockTasks.find(t => t.id === this.task_id);

            if (!this.task) {
              alert("Task not found.");
            }
          } catch (error) {
            console.error("Failed to load task detail:", error);
          } finally {
            this.loading = false;
          }
        },


        updateStatus(newStatus) {
          this.task.status = newStatus;
    
          // Optional: show toast or alert
          console.log(`Task status updated to: ${newStatus}`);
        },


        goBack() {
          this.$root.loadComponent("modules/task.js");
        }
    
    
  },
  template: `


        <div>
          <v-app-bar dense flat color="black">
            <v-btn icon @click="goBack">
              <v-icon>mdi-arrow-left</v-icon>
            </v-btn>
            <v-toolbar-title>Task Detail</v-toolbar-title>
          </v-app-bar>

          <v-container v-if="task && !loading" class="mt-10">
            <v-card>



            
              <v-card-title class="text-h6">{{ task.name }}</v-card-title>
              <v-card-subtitle class="mb-2">Assigned to: {{ task.assignee }}</v-card-subtitle>
              <v-card-text>
                <div><strong>Status:</strong> 
                  <v-chip
                    :color="task.status === 'Done' ? 'green' : task.status === 'In Progress' ? 'orange' : 'grey'"
                    text-color="white"
                    small
                  >
                    {{ task.status }}
                  </v-chip>
                </div>

                <div><strong>Due Date:</strong> {{ task.due_date }}</div>
                <div class="mt-3"><strong>Description:</strong></div>
                <div>{{ task.description }}</div>



                <div class="mt-5"><strong>Progress Timeline:</strong></div>

                <v-timeline align="start" side="end" density="compact">
                  <v-timeline-item
                    icon="mdi-clock-outline"
                    color="grey"
                    :fill-dot="task.status === 'Pending'"
                    :hide-dot="false"
                  >
                    <div>Pending</div>
                  </v-timeline-item>

                  <v-timeline-item
                    icon="mdi-wrench-outline"
                    color="orange"
                    :fill-dot="task.status === 'In Progress'"
                    :hide-dot="false"
                  >
                    <div>In Progress</div>
                  </v-timeline-item>

                  <v-timeline-item
                    icon="mdi-check-circle-outline"
                    color="green"
                    :fill-dot="task.status === 'Done'"
                    :hide-dot="false"
                  >
                    <div>Done</div>
                  </v-timeline-item>
                </v-timeline>








                
              </v-card-text>

              <v-divider class="my-2" />

              <v-card-actions>
                <v-btn
                  color="orange"
                  variant="outlined"
                  @click="updateStatus('In Progress')"
                  v-if="task.status !== 'In Progress'"
                >
                  Mark In Progress
                </v-btn>

                <v-btn
                  color="green"
                  variant="outlined"
                  @click="updateStatus('Done')"
                  v-if="task.status !== 'Done'"
                >
                  Mark as Done
                </v-btn>

                <v-btn
                  color="grey"
                  variant="outlined"
                  @click="updateStatus('Pending')"
                  v-if="task.status !== 'Pending'"
                >
                  Reset to Pending
                </v-btn>
              </v-card-actions>
            </v-card>
          </v-container>

          <v-progress-circular v-else indeterminate class="mx-auto mt-10" />
        </div>
   

  `,
  async mounted(){
    
    this.task_id = this.jsonData.task_id;
    this.loadTaskDetail();

  }
};